<?php

namespace App\Utilities;

use App\Utilities\Session;
use Firebase\JWT\JWT;

class Auth
{
    private static $instance;

    function __construct()
    {
        if (!empty(Session::get('uid'))) {
            $user = new \App\Models\User;
            $response = $user->getUser(array(Session::get('uid')));
            foreach ($response as $key => $value) {
                $this->{$key} = $value;
            }
        }
    }

    public static function check()
    {
        if (!empty(Session::get('uid'))) {
            return true;
        }
        return false;
    }

    public static function user()
    {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public static function token()
    {
        $id = null;
        if (empty(self::user()->id)) {
            $id = session_id();
        } else {
            $id = self::user()->id;
        }

        $secretKey  = hash_hmac('sha256', $id,  env('APP_KEY'));
        $tokenId    = base64_encode(random_bytes(16));
        $issuedAt   = new \DateTimeImmutable();
        // $expire     = $issuedAt->modify('+30 minutes')->getTimestamp(); // Add 60 seconds
        $expire     = $issuedAt->modify('+10 hours')->getTimestamp(); // Add 60 seconds

        $serverName = env('APP_URL');

        // Create the token as an array
        $data = [
            'iat'  => $issuedAt->getTimestamp(),    // Issued at: time when the token was generated
            'jti'  => $tokenId,                     // Json Token Id: an unique identifier for the token
            'iss'  => $serverName,                  // Issuer
            'nbf'  => $issuedAt->getTimestamp(),    // Not before
            'exp'  => $expire,                      // Expire
            'data' => [                             // Data related to the signer user
                'id' => $id, // User name
            ]
        ];

        // Encode the array to a JWT string.
        $jwt =  JWT::encode(
            $data,      //Data to be encoded in the JWT
            $secretKey, // The signing key
            'HS512'     // Algorithm used to sign the token, see https://tools.ietf.org/html/draft-ietf-jose-json-web-algorithms-40#section-3
        );

        return $jwt;
    }
}
