<?php

namespace App\Models;

//Tips for impelementing codes

use App\Core\Model;
use App\Core\Database;

class User extends Model
{

    public function getUser($array_data)
    {
        $query = "SELECT u.*,
        c.name as membership, 
        p.name as designation,
        cp.name as company 
        FROM `golf_users` u
        LEFT OUTER JOIN golf_clubs c 
        ON u.club_id = c.id
        LEFT OUTER JOIN golf_positions p
        ON u.position_id = p.id
        LEFT OUTER JOIN `golf_companies` cp
        ON u.company_id = cp.id
        WHERE 1 
        AND u.`id` = ?";
        $paramType = "i";
        $response = Database::connect()->runQuery($query, $paramType, $array_data);
        return count($response) > 0 ? $response[0] : $response;
    }

    public function getPlayer($array_data)
    {
        $query = "SELECT p.*,
        t.name as team_name,
        c.name as course_name,
        d.name as division_name,
        d.name as division_name,
        e.name as event_name,
        CONCAT(u.firstname,' ',u.lastname) as partner_name,
        CONCAT(un.firstname,' ',un.lastname) as player_name
         FROM golf_players p 
        LEFT OUTER JOIN golf_courses c 
        ON p.course_id = c.id
        LEFT OUTER JOIN golf_teams t
        ON p.team_id = t.id
        LEFT OUTER JOIN golf_divisions d
        ON p.division_id = d.id
        LEFT OUTER JOIN golf_users u 
        ON p.partner_id = u.id
        LEFT OUTER JOIN golf_users un 
        ON p.user_id = un.id
        LEFT OUTER JOIN golf_events e
        ON p.event_id = e.id
        WHERE 1
        AND p.event_id = ?
        AND p.user_id = ?     
        AND p.status = 1   
        ";
        $paramType = "ii";
        $response = Database::connect()->runQuery($query, $paramType, $array_data);
        return count($response) > 0 ? $response[0] : $response;
    }

    public function getPlayerData($array_data)
    {
        $query = "SELECT p.*,
        t.name as team_name,
        c.name as course_name,
        d.name as division_name,
        d.name as division_name,
        e.name as event_name,
        CONCAT(u.firstname,' ',u.lastname) as partner_name,
        CONCAT(un.firstname,' ',un.lastname) as player_name
         FROM golf_players p 
        LEFT OUTER JOIN golf_courses c 
        ON p.course_id = c.id
        LEFT OUTER JOIN golf_teams t
        ON p.team_id = t.id
        LEFT OUTER JOIN golf_divisions d
        ON p.division_id = d.id
        LEFT OUTER JOIN golf_users u 
        ON p.partner_id = u.id
        LEFT OUTER JOIN golf_users un 
        ON p.user_id = un.id
        LEFT OUTER JOIN golf_events e
        ON p.event_id = e.id
        WHERE 1
        AND p.id = ? 
        AND p.status = 1   
        ";
        $paramType = "i";
        $response = Database::connect()->runQuery($query, $paramType, $array_data);
        return count($response) > 0 ? $response[0] : $response;
    }
    public function getUsers()
    {
        $query = "SELECT * FROM `golf_users` WHERE 1 AND status = 1 AND active = 1  ";
        return Database::connect()->runBaseQuery($query);
    }

    public function getPlayers()
    {
        $query = "SELECT * FROM `golf_users` WHERE 1 AND status = 1 AND active = 1 AND is_admin IS NULL ";
        return Database::connect()->runBaseQuery($query);
    }

    public function getPlayersGroupByMobile()
    {
        $query = "SELECT * FROM `golf_users` WHERE 1 AND status = 1 AND active = 1 AND is_admin IS NULL GROUP BY mobile";
        return Database::connect()->runBaseQuery($query);
    }

    public function getEventPlayersGroupByMobileQuery()
    {
        return "SELECT u.* FROM `golf_users` u
        LEFT OUTER JOIN golf_players p 
        ON u.id = p.user_id
        /*LEFT OUTER JOIN golf_player_attendance pa
        ON p.id = pa.player_id*/
        WHERE 1 
        AND u.status = 1 
        AND u.active = 1 
        AND p.status = 1
        AND u.is_admin IS NULL 
        %s ";
    }

    public function getEventPlayersGroupByMobile($array_data)
    {
        $query = sprintf($this->getEventPlayersGroupByMobileQuery(), "
        AND p.registration_status = 'registered' 
        AND p.event_id = ? 
        ");

        $paramType = "i";
        return Database::connect()->runQuery($query, $paramType, $array_data);
    }


    public function getEventPlayersGroupByMobile2($filters)
    {
        $query = sprintf($this->getEventPlayersGroupByMobileQuery(), $filters);
        return Database::connect()->runBaseQuery($query);
    }

    public function getUserByEmail($array_data)
    {
        $query = "SELECT * FROM `golf_users` WHERE 1 AND `email` = ?";
        $paramType = "s";
        $response = Database::connect()->runQuery($query, $paramType, $array_data);
        return count($response) > 0 ? $response[0] : $response;
    }
    public function getUserByUsername($array_data)
    {
        $query = "SELECT * FROM `golf_users` WHERE 1 AND `username` = ?";
        $paramType = "s";
        $response = Database::connect()->runQuery($query, $paramType, $array_data);
        return count($response) > 0 ? $response[0] : $response;
    }

    public function getUserStatus($array_data)
    {
        $query = "SELECT * FROM `golf_users` WHERE 1 AND `id` = ? AND status = 1 AND active = 1";
        $paramType = "i";
        $response =  Database::connect()->runQuery($query, $paramType, $array_data);
        return count($response) > 0 ? $response[0] : $response;
    }

    public function createLoginToken($array_data)
    {
        $query = "INSERT INTO `golf_users_login_session_token`(`user_id`, `token`, `updated_at`,`status`) VALUES (?,?,NOW(),1) ON DUPLICATE KEY UPDATE    
							token  = VALUES (token),
                            updated_at = VALUES(updated_at),
                            status = VALUES(status)
                            ";
        $paramType = "is";
        $insertId =  Database::connect()->insert($query, $paramType, $array_data);
        return $insertId;
    }


    public function createLastLoginDate($array_data)
    {
        $query = "UPDATE golf_users SET last_login = NOW() WHERE id = ?";
        $paramType = "i";
        Database::connect()->update($query, $paramType, $array_data);
    }

    public function getUserIdBySessionToken($array_data)
    {
        $query = "SELECT user_id FROM golf_users_login_session_token WHERE token = ? AND status = 1";
        $paramType = "s";
        return Database::connect()->select($query, $paramType, $array_data);
    }

    public function createUser($array_data)
    {
        $query = "
        INSERT INTO `golf_users`
            (
            `firstname`,
            `middlename`,
            `lastname`,
            `suffix`,
            `mobile`,
            `email`,
            `other_mobile`,
            `other_email`,
            `phone`,
            `username`,
            `password`,
            `is_admin`,
            `created_at`,
            `updated_at`,
            `last_login`,
            `company_id`,
            `position_id`,
            `unhs_id`,
            `club_id`,
            `handicap`,
            `active`,
            `status`)
            VALUES
            (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)
            ON DUPLICATE KEY UPDATE 
            firstname  = VALUES (firstname), 
            lastname = VALUES(lastname),
            suffix = VALUES(suffix),
            email = VALUES(email),
            company_id = VALUES(company_id),
            position_id = VALUES(position_id),
            unhs_id = VALUES(unhs_id),
            club_id = VALUES(club_id),
            handicap = VALUES(handicap),
            other_email = VALUES(other_email),
            other_mobile = VALUES(other_mobile),
            phone = VALUES(phone),
            updated_at = NOW()
        ";
        $paramType = "sssssssssssisssiisisii";
        return Database::connect()->insert($query, $paramType, $array_data);
    }

    public function updateUser($array_data)
    {
        $query = "
     UPDATE `golf_users`
            SET
            `firstname` = ? ,
            `middlename` = ? ,
            `lastname` = ? ,
            `suffix` = ? ,
            `mobile` = ? ,
            `email` = ? ,
            `other_mobile` = ? ,
            `other_email` = ? ,
            `phone` = ? ,
            `username` = ? ,
            `password` = ? ,
            `is_admin` = ? ,
            `created_at` = ? ,
            `updated_at` = ? ,
            `last_login` = ? ,
            `company_id` = ? ,
            `position_id` = ? ,
            `unhs_id` = ? ,
            `club_id` = ? ,
            `handicap` = ? ,
            `active` = ? ,
            `status` =?
            WHERE 
            id = ?
        ";
        $paramType = "sssssssssssisssiisisiii";
        return Database::connect()->update($query, $paramType, $array_data);
    }

    public function getCompany($array_data)
    {
        $query = "SELECT * FROM `golf_companies` WHERE 1 AND `name` = ?";
        $paramType = "s";
        $response =  Database::connect()->runQuery($query, $paramType, $array_data);
        return count($response) > 0 ? $response[0] : $response;
    }
    public function createCompany($array_data)
    {
        $query = "INSERT INTO `golf_companies`
        (
        `name`,
        `status`)
        VALUES
        (
       ?,
        1);
        ";
        $paramType = "s";
        return Database::connect()->insert($query, $paramType, $array_data);
    }

    public function getPosition($array_data)
    {
        $query = "SELECT * FROM `golf_positions` WHERE 1 AND `name` = ?";
        $paramType = "s";
        $response =  Database::connect()->runQuery($query, $paramType, $array_data);
        return count($response) > 0 ? $response[0] : $response;
    }
    public function createPosition($array_data)
    {
        $query = "INSERT INTO `golf_positions`
        (
        `name`,
        `status`)
        VALUES
        (
       ?,
        1);
        ";
        $paramType = "s";
        return Database::connect()->insert($query, $paramType, $array_data);
    }
    public function getClub($array_data)
    {
        $query = "SELECT * FROM `golf_clubs` WHERE 1 AND `name` = ?";
        $paramType = "s";
        $response =  Database::connect()->runQuery($query, $paramType, $array_data);
        return count($response) > 0 ? $response[0] : $response;
    }

    public function getTeam($array_data)
    {
        $query = "SELECT * FROM `golf_teams` WHERE 1 AND event_id = ? AND `name` = ? ";
        $paramType = "is";
        $response =  Database::connect()->runQuery($query, $paramType, $array_data);
        return count($response) > 0 ? $response[0] : $response;
    }
    public function createClub($array_data)
    {
        $query = "INSERT INTO `golf_clubs`
        (
        `name`,
        `status`)
        VALUES
        (
       ?,
        1);
        ";
        $paramType = "s";
        return Database::connect()->insert($query, $paramType, $array_data);
    }

    public function getUserQuery()
    {
        return "SELECT %s FROM `golf_users` u
        WHERE 1 
        AND u.status = 1 
        AND u.active = 1 
        AND u.is_admin IS NULL 
        %s /*filters*/
        %s /*order*/
        %s /*limit*/
        
         ";
    }
    public function getUsersList($array_data)
    {
        $fields = " u.*,CONCAT(u.firstname,' ',u.lastname) as name ";
        $query = sprintf($this->getUserQuery(), $fields, $array_data['filters'], $array_data['sort'], $array_data['offset_limit']);


        $paramType = "s";
        $paramValue = array(
            $array_data['search_keyword'],
        );
        return Database::connect()->runQuery($query, $paramType, $paramValue);
    }

    public function getUsersListCount($array_data)
    {
        $fields = " COUNT(1) ";
        $query = sprintf(
            $this->getUserQuery(),
            $fields,
            'AND  ?',
            '',
            ''
        );
        $paramType = "s";
        $paramValue = array("1");
        return Database::connect()->select($query, $paramType, $paramValue);
    }

    public function getUsersListFilteredCount($array_data)
    {
        $fields = " COUNT(1) ";

        $query = sprintf(
            $this->getUserQuery(),
            $fields,
            $array_data['filters'],
            '',
            ''
        );
        $paramType = "s";
        $paramValue = array(
            $array_data['search_keyword'],
        );
        return Database::connect()->select($query, $paramType, $paramValue);
    }

    public function getDashboard($array_data)
    {
        $fields = " COUNT(1) ";

        $query = sprintf(
            $this->getEventUserQuery(),
            $fields,
            $array_data['filters'],
            $array_data['where'],
            '',
            ''
        );
        $paramType = "i";
        $paramValue = array(
            $array_data['id'],
        );
        return Database::connect()->select($query, $paramType, $paramValue);
    }

    public function getEventUserQuery()
    {
        return "SELECT %s FROM `golf_users` u
        LEFT OUTER JOIN golf_players p 
        ON u.id = p.user_id
        LEFT OUTER JOIN golf_player_attendance pa
        ON p.id = pa.player_id
        WHERE 1 
        AND u.status = 1 
        AND u.active = 1 
        AND p.status = 1
        AND u.is_admin IS NULL 
        AND p.event_id = ?
        %s /*filters*/
        %s /*where*/
        %s /*order*/
        %s /*limit*/
        
         ";
    }
    public function getEventUsersList($array_data)
    {
        $fields = " u.*,pa.created_at as attendance,
                    CONCAT(u.firstname,' ',u.lastname) as name,
                    p.id as player_id,p.registration_status,p.event_id,p.registration_type,p.registration_date,p.created_at as p_created_at ";
        $query = sprintf($this->getEventUserQuery(), $fields, $array_data['filters'], $array_data['where'], $array_data['sort'], $array_data['offset_limit']);
        // echo $query;
        // exit;

        $paramType = "is";
        $paramValue = array(
            $array_data['id'],
            $array_data['search_keyword'],
        );
        return Database::connect()->runQuery($query, $paramType, $paramValue);
    }
    
    public function checkPlayerAttendance($array_data)
    {
        $query = "SELECT created_at as attendance FROM golf_player_attendance WHERE player_id=".$array_data;
        return Database::connect()->runQueries($query);
    }

    public function getEventUsersListCount($array_data)
    {
        $fields = " COUNT(1) ";
        $query = sprintf(
            $this->getEventUserQuery(),
            $fields,
            'AND  ?',
            $array_data['where'],
            '',
            ''
        );
        $paramType = "is";
        $paramValue = array(
            $array_data['id'],
            "1",
        );
        return Database::connect()->select($query, $paramType, $paramValue);
    }

    public function getEventListFilteredCount($array_data)
    {
        $fields = " COUNT(1) ";

        $query = sprintf(
            $this->getEventUserQuery(),
            $fields,
            $array_data['filters'],
            $array_data['where'],
            '',
            ''
        );
        $paramType = "is";
        $paramValue = array(
            $array_data['id'],
            $array_data['search_keyword'],
        );
        return Database::connect()->select($query, $paramType, $paramValue);
    }



    public function getTeamUserQuery()
    {
        return "SELECT %s FROM `golf_users` u
        LEFT OUTER JOIN golf_players p 
        ON u.id = p.user_id
        LEFT OUTER JOIN golf_courses c 
        ON p.course_id = c.id
        LEFT OUTER JOIN golf_teams t
        ON p.team_id = t.id
        LEFT OUTER JOIN golf_divisions d
        ON p.division_id = d.id 
        LEFT OUTER JOIN golf_player_attendance pa
        ON p.id = pa.player_id
        LEFT OUTER JOIN golf_users fm
        ON p.partner_id = fm.id
        WHERE 1 
        AND u.status = 1 
        AND u.active = 1 
        AND p.status = 1
        AND u.is_admin IS NULL 
        AND p.event_id = ?
        /*AND p.team_id = ?*/
        %s /*all filter merge where */
        %s /*filters*/
        %s /*group*/
        %s /*order*/
        %s /*limit*/
        
         ";
    }


    public function getTeamUsersList($array_data)
    {
        $fields = " u.*,
                    CONCAT(u.firstname,' ',u.lastname) as name,
                    p.id as player_id,p.registration_status,p.event_id,p.registration_type,p.registration_date,p.created_at as p_created_at,
                    CONCAT(p.course,p.flight) as course_flight,
                    p.course as course_n,
                    p.flight as flight_n,
                    t.name as team,
                    c.name as course,
                    d.name as division,
                    pa.created_at as attendance,
                    CONCAT(fm.firstname,' ',fm.lastname) as partner
                     ";
        $query = sprintf($this->getTeamUserQuery(), $fields, $array_data['where'],  $array_data['filters'], '', $array_data['sort'], $array_data['offset_limit']);

        // echo $query;
        // exit;
        $paramType = "is";
        $paramValue = array(
            $array_data['event_id'],
            $array_data['search_keyword'],
        );
        return Database::connect()->runQuery($query, $paramType, $paramValue);
    }

    public function getTeamUsersListSame($array_data, $field)
    {
        $fields = $field;
        $query = sprintf($this->getTeamUserQuery(), $fields, $array_data['where'],  $array_data['filters'], ' GROUP BY ' . $field, $array_data['sort'], $array_data['offset_limit']);

        // echo $query;
        // exit;
        $paramType = "is";
        $paramValue = array(
            $array_data['event_id'],
            $array_data['search_keyword'],
        );
        return Database::connect()->runQuery($query, $paramType, $paramValue);
    }


    public function getTeamUsersListCount($array_data)
    {
        $fields = " COUNT(1) ";
        $query = sprintf(
            $this->getTeamUserQuery(),
            $fields,
            'AND  ?',
            '',
            '',
            '',
            ''
        );
        $paramType = "is";
        $paramValue = array(
            $array_data['event_id'],
            "1",
        );
        return Database::connect()->select($query, $paramType, $paramValue);
    }

    public function getTeamListFilteredCount($array_data)
    {
        $fields = " COUNT(1) ";

        $query = sprintf(
            $this->getTeamUserQuery(),
            $fields,
            $array_data['filters'],
            $array_data['where'],
            '',
            '',
            ''
        );
        $paramType = "is";
        $paramValue = array(
            $array_data['event_id'],
            $array_data['search_keyword'],
        );
        return Database::connect()->select($query, $paramType, $paramValue);
    }


    public function updateUserStatus($array_data)
    {
        $query = "UPDATE golf_users SET status = ?,active = ? WHERE id = ?";
        $paramType = "iii";
        return Database::connect()->update($query, $paramType, $array_data);
    }

    public function updateUserEventStatus($array_data)
    {
        $query = "UPDATE golf_players SET status =  ? WHERE id = ?";
        $paramType = "ii";
        return Database::connect()->update($query, $paramType, $array_data);
    }

    public function removeUserFromTeam($array_data)
    {
        $query = "UPDATE golf_players SET team_id = null WHERE id = ?";
        $paramType = "i";
        return Database::connect()->update($query, $paramType, $array_data);
    }

    public function getAdminQuery()
    {
        return "SELECT %s FROM golf_users u
        WHERE 1
        AND u.status = 1  
        AND u.is_admin = 1
        %s /*filters*/
        %s /*adminfilter*/
        %s /*order*/
        %s /*limit*/
        
         ";
    }
    public function getAdmins($array_data)
    {
        $fields = " u.*,CONCAT(u.firstname,' ',u.lastname)  as name";
        $query = sprintf($this->getAdminQuery(), $fields, $array_data['filters'], $array_data['admin_filter'], $array_data['sort'], $array_data['offset_limit']);


        $paramType = "si";
        $paramValue = array(
            $array_data['search_keyword'],
            $array_data['admin_id'],
        );
        return Database::connect()->runQuery($query, $paramType, $paramValue);
    }

    public function getAdminsCount($array_data)
    {
        $fields = " COUNT(1) ";
        $query = sprintf(
            $this->getAdminQuery(),
            $fields,
            'AND  ?',
            $array_data['admin_filter'],
            '',
            ''
        );
        $paramType = "si";
        $paramValue = array(
            "1",
            $array_data['admin_id'],
        );
        return Database::connect()->select($query, $paramType, $paramValue);
    }

    public function getAdminsFilteredCount($array_data)
    {
        $fields = " COUNT(1) ";

        $query = sprintf(
            $this->getAdminQuery(),
            $fields,
            $array_data['filters'],
            $array_data['admin_filter'],
            '',
            ''
        );
        $paramType = "si";
        $paramValue = array(
            $array_data['search_keyword'],
            $array_data['admin_id'],
        );
        return Database::connect()->select($query, $paramType, $paramValue);
    }
    public function getDivision()
    {
        $query = "SELECT * FROM `golf_divisions` WHERE 1 AND status = 1";
        return  Database::connect()->runBaseQuery($query);
    }

    public function getCourse()
    {
        $query = "SELECT * FROM `golf_courses` WHERE 1 AND status = 1";
        return  Database::connect()->runBaseQuery($query);
    }

    public function getCourseIdByName($paramValue)
    {
        $query = "SELECT id FROM `golf_courses` WHERE 1 AND name = ? AND status = 1";
        $paramType = "s";
        return  Database::connect()->select($query, $paramType, $paramValue);
    }

    public function getMate($paramValue)
    {
        $query = "SELECT p.partner_id FROM golf_players p
        WHERE 1
        AND p.event_id = ?
        AND p.user_id = ?
        AND p.status = 1";
        $paramType = "ii";
        return  Database::connect()->select($query, $paramType, $paramValue);
    }

    public function getMateData($paramValue)
    {
        $query = "SELECT * FROM 
        
        SELECT * FROM golf_players p
        WHERE 1
        AND p.event_id = ?
        AND p.user_id = ?
        AND p.status = 1";
        $paramType = "ii";
        return  Database::connect()->select($query, $paramType, $paramValue);
    }
    public function createTeam($array_data)
    {
        $query = "INSERT INTO `golf_teams` (`event_id`,`name`,`created_at`,`status`) VALUES (?,?,?,?) ON DUPLICATE KEY UPDATE created_at = NOW()";
        $paramType = "issi";
        return  Database::connect()->insert($query, $paramType, $array_data);
    }
    public function createPlayer($array_data)
    {
        $query = "INSERT INTO `golf_players`
        (
        `event_id`,
        `course_id`,
        `team_id`,
        `division_id`,
        `user_id`,
        `course`,
        `flight`,
        `partner_id`,
        `registration_status`,
        `registration_type`,
        `registration_date`,
        `created_at`,
        `status`) 
        VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?) 
        ON DUPLICATE KEY UPDATE    
        course_id  = VALUES (course_id),
        team_id = VALUES(team_id),
        division_id = VALUES(division_id),
        course = VALUES(course),
        flight = VALUES(flight),
        partner_id = VALUES(partner_id),
        registration_status = VALUES(registration_status),
        registration_type = VALUES(registration_type),
        registration_date = VALUES(registration_date),
        partner_id = VALUES(partner_id),
        status = VALUES(status),
        updated_at = NOW()

        ";
        $paramType = "iiiiississssi";
        return  Database::connect()->insert($query, $paramType, $array_data);
    }
    public function getUserOptions($array_data)
    {
        $query = "SELECT u.id,CONCAT(u.firstname,' ',u.lastname) as text FROM golf_users u
                WHERE 1 
                AND CONCAT(u.lastname,', ',u.firstname,' ',u.lastname,' ',u.firstname) LIKE ?
                AND u.status = 1 
                AND u.active = 1 
                AND u.is_admin IS NULL
                AND u.id NOT IN (?)
                ORDER BY `text` ASC
                LIMIT ?";

        $paramType = "sii";
        return  Database::connect()->runQuery($query, $paramType, $array_data);
    }
    public function getUserMateOptions($array_data)
    {
        $query = "SELECT u.id,CONCAT(u.firstname,' ',u.lastname) as text FROM golf_users u
        INNER JOIN golf_players p
        ON u.id = p.user_id
                WHERE 1 
                AND CONCAT(u.lastname,', ',u.firstname,' ',u.lastname,' ',u.firstname) LIKE ?
                AND u.status = 1 
                AND u.active = 1 
                AND u.is_admin IS NULL
                AND u.id NOT IN (?)
                AND p.event_id = ?
                AND p.course = ?
                AND p.flight = ? 
                AND p.course_id = ?
                AND p.status = 1 
                ORDER BY `text` ASC
                LIMIT ?";

        $paramType = "siissii";
        return  Database::connect()->runQuery($query, $paramType, $array_data);
    }
    public function getUserEventTeamOptions($array_data)
    {
        $query = "SELECT u.id,CONCAT(u.firstname,' ',u.lastname) as text FROM golf_users u
        LEFT OUTER JOIN golf_players p
        ON u.id = p.user_id
                WHERE 1 
                AND CONCAT(u.lastname,', ',u.firstname,' ',u.lastname,' ',u.firstname) LIKE ?
                AND u.status = 1 
                AND u.active = 1 
                AND u.is_admin IS NULL
                AND (SELECT COUNT(1) FROM (
                    (SELECT id FROM golf_players WHERE status = 1 AND team_id = ? AND user_id = p.user_id GROUP BY user_id)
                ) t1) = 0
                /*AND ((p.team_id NOT IN (?)  OR p.team_id IS NULL) OR (p.event_id NOT IN (?)  OR p.event_id IS NULL))*/
                GROUP BY u.id
                ORDER BY `text` ASC
                LIMIT ?";

        // echo $query;
        // exit;

        $paramType = "sii";
        return  Database::connect()->runQuery($query, $paramType, $array_data);
    }
    public function getTeamOptions($array_data)
    {
        $query = "SELECT t.id,t.name as text FROM golf_teams t
                WHERE 1 
                AND name LIKE ?
                AND t.event_id = ?
                AND t.status = 1  
                ORDER BY `text` ASC
                LIMIT ?";

        $paramType = "sii";
        return  Database::connect()->runQuery($query, $paramType, $array_data);
    }

    public function getTeamFilterOptions($array_data)
    {
        $query = "SELECT t.id,t.name as text FROM golf_teams t
                WHERE 1 
                AND (SELECT COUNT(1) FROM `golf_users` u
                    LEFT OUTER JOIN golf_players p 
                    ON u.id = p.user_id 
                    LEFT OUTER JOIN golf_teams tsub
                    ON p.team_id = tsub.id 
                    WHERE 1 
                    AND u.status = 1 
                    AND u.active = 1 
                    AND p.status = 1
                    AND p.course IS NOT NULL 
                    AND p.flight IS NOT NULL 
                    AND p.course_id IS NOT NULL 
                    AND tsub.id = t.id
                    AND u.is_admin IS NULL 
                    AND p.event_id = t.event_id) > 0
                AND name LIKE ?
                AND t.event_id = ?
                AND t.status = 1  
                ORDER BY `text` ASC
                LIMIT ?";

        $paramType = "sii";
        return  Database::connect()->runQuery($query, $paramType, $array_data);
    }
    public function createReward($array_data)
    {
        $query = "INSERT INTO `golf_rewards`
        (
        `event_id`,
        `user_id`,
        `player_id`,
        `created_at`,
        `status`)
        VALUES
        (?,?,?,?,?)
        ";
        $paramType = "iiisi";
        return Database::connect()->insert($query, $paramType, $array_data);
    }

    public function createRewardQR($array_data)
    {
        $query = "INSERT INTO `golf_rewards`
        (
        `event_id`, 
        `player_id`,
        `created_at`,
        `status`)
        VALUES
        (?,?,?,?)
        ";
        $paramType = "iisi";
        return Database::connect()->insert($query, $paramType, $array_data);
    }

    public function getRewardCount($array_data)
    {
        $query = "SELECT COUNT(1) FROM golf_rewards WHERE  1 AND `event_id` = ? AND player_id = ?  AND status = 1";
        $paramType = "ii";
        return Database::connect()->select($query, $paramType, $array_data);
    }
    public function getMulliganCount($array_data)
    {
        $query = "SELECT mulligan FROM golf_mulligans WHERE  1 AND `event_id` = ? AND player_id = ? AND status = 1 ";
        $paramType = "ii";
        return Database::connect()->select($query, $paramType, $array_data);
    }
    public function updateMulligan($array_data)
    {
        $query = "INSERT INTO  `golf_mulligans`
        (
        `event_id`,
        `mulligan`,
        `user_id`,
        `player_id`,
        `updated_at`,
        `status`)
        VALUES
        (?,?,?,?,?,?) ON DUPLICATE KEY UPDATE    
        mulligan  = VALUES (mulligan),
                            updated_at = VALUES(updated_at),
                            user_id = VALUES(user_id)
        ";
        $paramType = "iiiisi";
        return Database::connect()->insert($query, $paramType, $array_data);
    }

    public function updateMulliganQR($array_data)
    {
        $query = "INSERT INTO  `golf_mulligans`
        (
        `event_id`,
        `mulligan`, 
        `player_id`,
        `updated_at`,
        `status`)
        VALUES
        (?,?,?,?,?) ON DUPLICATE KEY UPDATE    
        mulligan  = VALUES (mulligan),
                            updated_at = VALUES(updated_at)
        ";
        $paramType = "iiisi";
        return Database::connect()->insert($query, $paramType, $array_data);
    }

    public function getDeviceIds()
    {
        $query = "SELECT * FROM `golf_devices` WHERE 1  AND status = 1";
        return Database::connect()->runBaseQuery($query);
    }

    public function getPlayerAttendance($array_data)
    {
        $query = "SELECT COUNT(1) FROM golf_player_attendance WHERE  1 AND `player_id` = ? AND  status = 1 ";
        $paramType = "i";
        return Database::connect()->select($query, $paramType, $array_data);
    }
    public function setPlayerAttendance($array_data)
    {
        $query = "INSERT INTO `golf_player_attendance`
        (
        `player_id`,
        `created_at`,
        `status`)
        VALUES (?,?,?)";
        $paramType = "isi";
        return Database::connect()->insert($query, $paramType, $array_data);
    }

    public function removePlayerAttendance($array_data)
    {
        $query = "DELETE FROM `golf_player_attendance` WHERE player_id = ?";
        $paramType = "i";
        return Database::connect()->insert($query, $paramType, $array_data);
    }
    
    public function inserBootClaimed($array_data)
    {
        $query = "INSERT IGNORE INTO `event_booth_player`
        (
        `event_id`,
        `player_id`,
        `booth_id`,
        `created_at`,
        `is_claim`)
        VALUES (?,?,?,NOW(),1)";
        $paramType = "iii";
        Database::transBegin();
        $res = (Database::connect()->insert($query, $paramType, $array_data) > 0 ? true : false);
        ($res  ? Database::transCommit() : Database::transRollback());
        return $res;
       
    }

     public function updateBootClaim($array_data)
    {
        // $query = "UPDATE `event_booth_player` SET active =0 WHERE event_id =".$array_data[0]." AND  player_id=".$array_data[1]." AND booth_id=".$array_data[2]." AND active =1";
        // return Database::connect()->runQueries($query);
        //  Database::transBegin();
        //  $res = (Database::connect()->runQueries($query) ? true :false);
        //   ($res  ? Database::transCommit() : Database::transRollback());
        // return $res;

        $query = "UPDATE `event_booth_player` SET active =0 WHERE event_id =? AND  player_id=? AND booth_id=? AND active =1";
        $paramType = "iii";
        Database::transBegin();
        $res = (Database::connect()->update($query, $paramType, $array_data) ==1 ? true : false);
        ($res  ? Database::transCommit() : Database::transRollback());
        return $res;
    }
    
    public function createDevice($array_data)
    {
        $query = "INSERT IGNORE INTO `golf_devices`
        (
        `device_id`,
        `description`,
        `created_at`)
        VALUES (?,?,NOW())";
        $paramType = "ss";
        return Database::connect()->insert($query, $paramType, $array_data);
    }
}
