<?php

namespace App\Controllers;

use App\Core\Controller;
use App\Core\View;
use App\Utilities\Uuid;
use App\Utilities\Cookie;
use App\Utilities\Utility;
use App\Utilities\Session;
use Firebase\JWT\JWT;
use App\Utilities\Auth;

class UserController extends Controller
{
    private $user;
    function __construct()
    {
        $this->user = new \App\Models\User;
    }
    public function usersIndex()
    {
        $page_title = "Players List";

        $course_options = "";
        $division_options = "";

        $course_response = $this->user->getCourse();
        foreach ($course_response as $course_response_row) {
            $course_options .= "<option value='" . $course_response_row['id'] . "'>" . $course_response_row['name'] . "</option>";
        }
        $division_response = $this->user->getDivision();
        foreach ($division_response as $division_response_row) {
            $division_options .= "<option value='" . $division_response_row['id'] . "'>" . $division_response_row['name'] . "</option>";
        }

        View::render('user/list', get_defined_vars());
    }

    public function usersImportIndex()
    {
        View::render('user/import', get_defined_vars());
    }

    public function teamsIndex()
    {
        $page_title = "Team";
        $course_options = "";
        $division_options = "";

        $course_response = $this->user->getCourse();
        foreach ($course_response as $course_response_row) {
            $course_options .= "<option value='" . $course_response_row['id'] . "'>" . $course_response_row['name'] . "</option>";
        }
        $division_response = $this->user->getDivision();
        foreach ($division_response as $division_response_row) {
            $division_options .= "<option value='" . $division_response_row['id'] . "'>" . $division_response_row['name'] . "</option>";
        }

        View::render('team/list', get_defined_vars());
    }

    public function courseFlightIndex()
    {
        $page_title = "Course & Flight";
        $course_options = "";
        $division_options = "";

        $course_response = $this->user->getCourse();
        foreach ($course_response as $course_response_row) {
            $course_options .= "<option value='" . $course_response_row['id'] . "'>" . $course_response_row['name'] . "</option>";
        }
        $division_response = $this->user->getDivision();
        foreach ($division_response as $division_response_row) {
            $division_options .= "<option value='" . $division_response_row['id'] . "'>" . $division_response_row['name'] . "</option>";
        }

        View::render('course_flight/list', get_defined_vars());
    }


    public function courseFlightIndexPublic($event_id)
    {

        // Session::set(['uid' => 1, 'agent' => $_SERVER['HTTP_USER_AGENT'], 'public' => true]);

        $page_title = "Course & Flight";
        $course_options = "";
        $division_options = "";

        $course_response = $this->user->getCourse();
        foreach ($course_response as $course_response_row) {
            $course_options .= "<option value='" . $course_response_row['id'] . "'>" . $course_response_row['name'] . "</option>";
        }
        $division_response = $this->user->getDivision();
        foreach ($division_response as $division_response_row) {
            $division_options .= "<option value='" . $division_response_row['id'] . "'>" . $division_response_row['name'] . "</option>";
        }

        $no_side = 1;

        View::render('course_flight/public_list', get_defined_vars());
    }

    public function list()
    {
        $array_data['search_keyword'] = input('search')['value'];
        $array_data['search_type'] = json_decode(input('search_type'), true)[0];
        $array_data['sort'] = input('order')[0]['dir'];
        $array_data['order'] = input('columns')[input('order')[0]['column']]['data'];
        $array_data['offset'] = input('start');
        $array_data['limit'] = input('length');

        $array_data['offset_limit'] = " LIMIT {$array_data['offset']},{$array_data['limit']}";
        $array_data['sort'] = intval(input('draw')) == 1 ?  " ORDER BY name ASC " : " ORDER BY {$array_data['order']} {$array_data['sort']} ";

        //start search using keywords
        if (empty($array_data['search_keyword'])) {
            $array_data['search_keyword'] = "1";
            $array_data['filters'] = " AND  ? ";
        } else {
            switch ($array_data['search_type']) {
                case "ID":
                    $array_data['filters'] = " AND u.id = ? ";
                    break;
                case "Name":
                    $array_data['filters'] = " AND CONCAT(u.lastname,', ',u.firstname,' ',u.lastname,' ',u.firstname) LIKE ? ";
                    $array_data['search_keyword'] = "%" . $array_data['search_keyword'] . "%";
                    break;
                case "Email":
                    $array_data['filters'] = " AND u.email = ? ";
                    break;
                case "Mobile":
                    $array_data['search_keyword'] = ltrim($array_data['search_keyword'], '0');
                    $array_data['filters'] = " AND u.mobile = ? ";
                    break;
            }
        }

        $results =  $this->user->getUsersList($array_data);

        $result['data'] = array();
        foreach ($results as $row) {
            $row  = Utility::emptyNullArray($row);
            $result['data'][] = array(
                "id" => $row['id'],
                "name" => $row['name'],
                "mobile" => $row['mobile'],
                "email" => $row['email'],
                "created_at" => $row['created_at'] ? date('m/d/Y', strtotime($row['created_at'])) : NULL,

            );
        }

        $result['draw'] = input('draw');
        $result['recordsTotal'] = $this->user->getUsersListCount($array_data);
        $result['recordsFiltered'] = $this->user->getUsersListFilteredCount($array_data);

        response()->json($result);
    }
    public function eventsData()
    {


        $array_data['search_keyword'] = input('search')['value'];
        $array_data['search_type'] = json_decode(input('search_type'), true)[0];
        $array_data['sort'] = input('order')[0]['dir'];
        $array_data['order'] = input('columns')[input('order')[0]['column']]['data'];
        $array_data['offset'] = input('start');
        $array_data['limit'] = input('length');
        $array_data['id'] = input('id');


        $array_data['course'] = !empty(input('course')) ? (input('course') == 'no' ? ' AND p.course_id IS NULL ' : ' AND p.course_id = ' . input('course')) : '';
        $array_data['division'] = !empty(input('division')) ? (input('division') == 'no' ? ' AND p.division_id IS NULL ' : ' AND p.division_id = ' . input('division')) : '';
        $array_data['course_n'] = !empty(input('course_n')) ? (input('course_n') == 'no' ? ' AND p.course IS NULL ' : ' AND p.course = "' . input('course_n') . '"') : '';
        $array_data['flight_n'] = !empty(input('flight_n')) ? (input('flight_n') == 'no' ? ' AND p.flight IS NULL ' : ' AND p.flight = "' . input('flight_n') . '"') : '';
        // $array_data['course_n'] = !empty(input('course_n')) ? ' AND p.course = "' . input('course_n') . '"' : '';
        // $array_data['flight_n'] = !empty(input('flight_n')) ? ' AND p.flight = "' . input('flight_n') . '"' : '';


        $array_data['offset_limit'] = " LIMIT {$array_data['offset']},{$array_data['limit']}";
        $array_data['sort'] = intval(input('draw')) == 1 ?  " ORDER BY name ASC " : " ORDER BY {$array_data['order']} {$array_data['sort']} ";

        //start search using keywords
        if (empty($array_data['search_keyword'])) {
            $array_data['search_keyword'] = "1";
            $array_data['filters'] = " AND  ? ";
        } else {
            switch ($array_data['search_type']) {
                case "ID":
                    $array_data['filters'] = " AND u.id = ? ";
                    break;
                case "Name":
                    $array_data['filters'] = " AND CONCAT(u.lastname,', ',u.firstname,' ',u.lastname,' ',u.firstname) LIKE ? ";
                    $array_data['search_keyword'] = "%" . $array_data['search_keyword'] . "%";
                    break;
                case "Email":
                    $array_data['filters'] = " AND u.email = ? ";
                    break;
                case "Mobile":
                    $array_data['search_keyword'] = ltrim($array_data['search_keyword'], '0');
                    $array_data['filters'] = " AND u.mobile = ? ";
                    break;
            }
        }


        $array_data['where'] = $array_data['division'] . $array_data['course'] . $array_data['course_n'] . $array_data['flight_n'];

        $results =  $this->user->getEventUsersList($array_data);

        $result['data'] = array();
        foreach ($results as $row) {
            $row  = Utility::emptyNullArray($row);
            $attendance = date('h:i A', strtotime($row['attendance']));
            $result['data'][] = array(
                "id" => $row['id'],
                "player_id" => $row['player_id'],
                "name" => $row['name'],
                "mobile" => $row['mobile'],
                "email" => $row['email'],
                "created_at" => $row['created_at'] ? date('m/d/Y', strtotime($row['created_at'])) : NULL,
                "registration_status" => $row['registration_status'],
                "registration_type" => $row['registration_type'],
                "attendance" => $row['attendance'] ? sprintf("%s %s", $attendance, "&nbsp;&nbsp;<span data-action-remove-attendance class='cursor-pointer text-md'><i class='fa fa-times'></i></span>") : NULL,
                "registration_date" =>  $row['registration_date'] ? date('m/d/Y', strtotime($row['registration_date'])) : NULL,
                "p_created_at" => $row['p_created_at'] ? date('m/d/Y', strtotime($row['p_created_at'])) : NULL,

            );
        }

        $result['draw'] = input('draw');
        $result['recordsTotal'] = $this->user->getEventUsersListCount($array_data);
        $result['recordsFiltered'] = $this->user->getEventListFilteredCount($array_data);

        response()->json($result);
    }


    public function store()
    {


        $data_fname = input('firstname');
        $data_lname = input('lastname');
        $data_suffix = input('suffix');
        $data_mobile = input('mobile');
        $data_other_mobile = input('other_mobile');
        $data_phone = input('phone');

        // //split mobile
        // $mobile_arr = explode("/", $data_mobile);
        // if (empty($mobile_arr[1])) {
        //     $data_mobile = Utility::remove_non_numeric($data_mobile);
        //     $data_mobile = Utility::fix_mobile_format($data_mobile);

        //     $data_other_mobile = null;
        // } else {
        //     $data_mobile = Utility::remove_non_numeric($mobile_arr[0]);
        //     $data_mobile = Utility::fix_mobile_format($data_mobile);

        //     $data_other_mobile = $mobile_arr[1];
        //     $data_other_mobile = Utility::remove_non_numeric($data_other_mobile);
        //     $data_other_mobile = Utility::fix_mobile_format($data_other_mobile);
        // }

        if (!empty($data_mobile)) {
            $data_mobile = Utility::remove_non_numeric($data_mobile);
            $data_mobile = Utility::fix_mobile_format($data_mobile);
        }
        if (!empty($data_other_mobile)) {
            $data_other_mobile = Utility::remove_non_numeric($data_other_mobile);
            $data_other_mobile = Utility::fix_mobile_format($data_other_mobile);
        }


        $data_email = input('email');
        $data_other_email = input('other_email');

        // $email_arr = explode("/", $data_email);
        // if (empty($email_arr[1])) {
        //     $data_email = Utility::validateEmail($data_email);

        //     $data_other_email = null;
        // } else {
        //     $data_email = Utility::validateEmail($email_arr[0]);

        //     $data_other_email = $email_arr[1];
        //     $data_other_email = Utility::validateEmail($data_other_email);
        // }

        if (!empty($data_email)) {
            $data_email = Utility::validateEmail($data_email);
        }
        if (!empty($data_other_email)) {
            $data_other_email = Utility::validateEmail($data_other_email);
        }


        $data_membership =  input('membership');
        $data_handicap = input('handicap');
        $data_unhs = null;
        $data_company = input('company');
        $data_designation =  input('designation');

        if (empty($data_company)) {
            $data_company_id = null;
        } else {
            // $data_company = Utility::removeNonAscii($data_company);
            $data_company_arr = $this->user->getCompany(array($data_company));
            if (empty($data_company_arr)) {
                $data_company_id =  $this->user->createCompany(array($data_company));
            } else {
                $data_company_id = $data_company_arr['id'];
            }
        }
        if (empty($data_designation)) {
            $data_designation_id = null;
        } else {
            // $data_designation = Utility::removeNonAscii($data_designation);
            $data_designation_arr = $this->user->getPosition(array($data_designation));
            if (empty($data_designation_arr)) {
                $data_designation_id =  $this->user->createPosition(array($data_designation));
            } else {
                $data_designation_id = $data_designation_arr['id'];
            }
        }

        if (empty($data_membership)) {
            $data_membership_id = null;
        } else {
            // $data_membership = Utility::removeNonAscii($data_membership);
            $data_membership_arr = $this->user->getClub(array($data_membership));
            if (empty($data_membership_arr)) {
                $data_membership_id =  $this->user->createClub(array($data_membership));
            } else {
                $data_membership_id = $data_membership_arr['id'];
            }
        }

        $array_data = array(
            $data_fname,
            null,
            $data_lname,
            $data_suffix,
            $data_mobile,
            $data_email,
            $data_other_mobile,
            $data_other_email,
            $data_phone,
            null,
            null,
            null,
            date('Y-m-d H:i:s'),
            null,
            null,
            $data_company_id,
            $data_designation_id,
            $data_unhs,
            $data_membership_id,
            $data_handicap,
            1,
            1,
        );

        $array_data = Utility::nullEmptyArray($array_data);

        if (input('user_id')) {
            $id = input('user_id');
            $array_data[] = $id;
            $this->user->updateUser($array_data);
        } else {
            $id = $this->user->createUser($array_data);
        }




        response()->json(array("status" => 1, "id" => $id, "name" => $data_fname . ' ' . $data_lname, "message" => "success"));
    }

    public function storeTeam()
    {
        $array_data = array(
            input('event_id'),
            input('team_name'),
            date('Y-m-d H:i:s'),
            1,
        );

        $array_data = array_map(array(new Utility(), 'cleanString'), $array_data);
        $array_data = Utility::nullEmptyArray($array_data);
        // $array_data = array_map(array(new Utility(), 'toUpperCase'), $array_data);

        // if (input('event_id')) {
        //     $array_data[] = input('event_id');
        //     unset($array_data[1]);
        //     $array_data = array_values($array_data);
        //     $event_id = input('event_id');
        //     $this->event->updateEvent($array_data);
        // } else {
        $team_id = $this->user->createTeam($array_data);
        // }
        if (!is_numeric($team_id)) {
            response()->json(array(
                "status" => 2,
                "message" => "Team name already added.",
            ));
        }

        response()->json(array(
            "status" => 1,
            "team_id" => $team_id,
            "name" =>  input('team_name'),
            "message" => "Successfully saved.",
        ));
    }
    public function usersImport()
    {

        ini_set('max_execution_time', '0');
        set_time_limit(0);
        //same code above
        ini_set('memory_limit', '-1');

        $disk_dir = env('APP_DISK') . input('dir');
        if (!file_exists($disk_dir)) {
            mkdir($disk_dir, 0777, true);
        }

        $log_dir = env('APP_DISK') . input('log_dir');
        if (!file_exists($log_dir)) {
            mkdir($log_dir, 0777, true);
        }


        $import = new \App\Models\Import;

        $import_fields = array(
            'FIRST NAME',
            'LAST NAME',
            'SUFFIX',
            'MOBILE NUMBER',
            'MOBILE NUMBER 2',
            'PHONE',
            'EMAIL ADDRESS',
            'EMAIL ADDRESS 2',
            'MEMBERSHIP',
            'HANDICAP INDEX',
            'UNHS ID',
            'COMPANY',
            'DESIGNATION',
        );


        $object = input()->file('file', $defaultValue = null);
        if ($object->getSize() <= 0) {
            $response['message'] = "File is empty";
            $response['status'] = 0;
            response()->json($response);
        } else {
            //check extension
            $valid_ext =  array('xls', 'csv', 'xlsx');
            if (!in_array($object->getExtension(), $valid_ext)) {
                $response['message'] = "Invalid file extension";
                $response['status'] = 0;
                response()->json($response);
            }

            //gen filename
            $destinationFilename = sprintf('%s.%s', Uuid::long(), $object->getExtension());
            //move file
            $full_dir = $disk_dir . '/' . $destinationFilename;
            $object->move($full_dir);

            // start import process
            $GLOBALS['total_data_count'] = 0;
            $GLOBALS['not_inserted_data_count'] = 0;
            $GLOBALS['inserted_data_count'] = 0;
            $GLOBALS['not_inserted_list_v2'] = array();
            $GLOBALS['data_count_list_v2'] = array();

            $file_type = \PhpOffice\PhpSpreadsheet\IOFactory::identify($full_dir);
            $reader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($file_type);
            try {

                $spreadsheet = $reader->load($full_dir);
                //remove excel after store to phpspreadsheet
                unlink($full_dir);

                $data = $spreadsheet->getActiveSheet()->toArray();
                $highestRow = $spreadsheet->getActiveSheet()->getHighestRow();
                $highestColumn =  $spreadsheet->getActiveSheet()->getHighestColumn();
                $ColumnNumber = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::columnIndexFromString($highestColumn);

                $data = array_map(array(new Utility(), 'removeNonAscii'), $data);
                $data = array_map(array(new Utility(), 'toUpperCase'), $data);

                $header_column_found = false;
                foreach ($data as $row) {
                    if (!empty(array_filter($row))) {
                        // echo 'Not empty row';
                    } else {
                        continue;
                    }
                    // $row = array_filter($row);
                    // $row = array_values($row);

                    if (!$header_column_found) {

                        // get matched field from database and excel globals
                        $issue_summary_index = $import->getSummaryIndex('SUMMARY', $ColumnNumber, $row);
                        $GLOBALS['fname'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[0]));
                        $GLOBALS['lname'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[1]));
                        $GLOBALS['suffix'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[2]));
                        $GLOBALS['mobile'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[3]));
                        $GLOBALS['other_mobile'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[4]));
                        $GLOBALS['phone'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[5]));
                        $GLOBALS['email'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[6]));
                        $GLOBALS['other_email'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[7]));
                        $GLOBALS['membership'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[8]));
                        $GLOBALS['handicap'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[9]));
                        $GLOBALS['unhs'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[10]));
                        $GLOBALS['company'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[11]));
                        $GLOBALS['designation'] = $import->getFieldName($row, $ColumnNumber, array($import_fields[12]));


                        // check required fields
                        if (
                            !empty($GLOBALS['fname']) &&
                            !empty($GLOBALS['lname']) //&&
                            // !empty($GLOBALS['mobile'])
                        ) {
                            $header_column_found = true;
                            $GLOBALS['row_headers'] = $row;
                            continue;
                        }
                    } else {
                        $GLOBALS['total_data_count']++;

                        $data_fname = $import->checkExist($row, $GLOBALS['fname'], $GLOBALS['row_headers']);
                        $data_lname = $import->checkExist($row, $GLOBALS['lname'], $GLOBALS['row_headers']);
                        $data_suffix = $import->checkExist($row, $GLOBALS['suffix'], $GLOBALS['row_headers']);
                        $data_suffix = Utility::alphaNumericOnly($data_suffix);

                        $data_mobile = $import->checkExist($row, $GLOBALS['mobile'], $GLOBALS['row_headers']);
                        $data_other_mobile = $import->checkExist($row, $GLOBALS['other_mobile'], $GLOBALS['row_headers']);
                        $data_phone = $import->checkExist($row, $GLOBALS['phone'], $GLOBALS['row_headers']);

                        // split mobile
                        // $mobile_arr = explode("/", $data_mobile);
                        // if (empty($mobile_arr[1])) {
                        //     $data_mobile = Utility::remove_non_numeric($data_mobile);
                        //     $data_mobile = Utility::fix_mobile_format($data_mobile);

                        //     $data_other_mobile = null;
                        // } else {
                        //     $data_mobile = Utility::remove_non_numeric($mobile_arr[0]);
                        //     $data_mobile = Utility::fix_mobile_format($data_mobile);

                        //     $data_other_mobile = $mobile_arr[1];
                        //     $data_other_mobile = Utility::remove_non_numeric($data_other_mobile);
                        //     $data_other_mobile = Utility::fix_mobile_format($data_other_mobile);
                        // }

                        if (!empty($data_mobile)) {
                            $data_mobile = Utility::remove_non_numeric($data_mobile);
                            $data_mobile = Utility::fix_mobile_format($data_mobile);
                        }
                        if (!empty($data_other_mobile)) {
                            $data_other_mobile = Utility::remove_non_numeric($data_other_mobile);
                            $data_other_mobile = Utility::fix_mobile_format($data_other_mobile);
                        }

                        $data_email = $import->checkExist($row, $GLOBALS['email'], $GLOBALS['row_headers']);
                        $data_other_email = $import->checkExist($row, $GLOBALS['other_email'], $GLOBALS['row_headers']);
                        // $email_arr = explode("/", $data_email);
                        // if (empty($email_arr[1])) {
                        //     $data_email = Utility::validateEmail($data_email);

                        //     $data_other_email = null;
                        // } else {
                        //     $data_email = Utility::validateEmail($email_arr[0]);

                        //     $data_other_email = $email_arr[1];
                        //     $data_other_email = Utility::validateEmail($data_other_email);
                        // }

                        if (!empty($data_email)) {
                            $data_email = Utility::validateEmail($data_email);
                        }
                        if (!empty($data_other_email)) {
                            $data_other_email = Utility::validateEmail($data_other_email);
                        }


                        $data_membership = $import->checkExist($row, $GLOBALS['membership'], $GLOBALS['row_headers']);
                        $data_handicap = $import->checkExist($row, $GLOBALS['handicap'], $GLOBALS['row_headers']);
                        $data_unhs = $import->checkExist($row, $GLOBALS['unhs'], $GLOBALS['row_headers']);
                        $data_company = $import->checkExist($row, $GLOBALS['company'], $GLOBALS['row_headers']);
                        $data_designation = $import->checkExist($row, $GLOBALS['designation'], $GLOBALS['row_headers']);

                        if (empty($data_company)) {
                            $data_company_id = null;
                        } else {
                            // $data_company = Utility::removeNonAscii($data_company);
                            $data_company_arr = $this->user->getCompany(array($data_company));
                            if (empty($data_company_arr)) {
                                $data_company_id =  $this->user->createCompany(array($data_company));
                            } else {
                                $data_company_id = $data_company_arr['id'];
                            }
                        }
                        if (empty($data_designation)) {
                            $data_designation_id = null;
                        } else {
                            // $data_designation = Utility::removeNonAscii($data_designation);
                            $data_designation_arr = $this->user->getPosition(array($data_designation));
                            if (empty($data_designation_arr)) {
                                $data_designation_id =  $this->user->createPosition(array($data_designation));
                            } else {
                                $data_designation_id = $data_designation_arr['id'];
                            }
                        }

                        if (empty($data_membership)) {
                            $data_membership_id = null;
                        } else {
                            // $data_membership = Utility::removeNonAscii($data_membership);
                            $data_membership_arr = $this->user->getClub(array($data_membership));
                            if (empty($data_membership_arr)) {
                                $data_membership_id =  $this->user->createClub(array($data_membership));
                            } else {
                                $data_membership_id = $data_membership_arr['id'];
                            }
                        }

                        //Validations
                        if (empty($data_fname)) {
                            $GLOBALS['not_inserted_list_v2'][] = array_merge(array("NO FIRST NAME"), $row);
                            $GLOBALS['not_inserted_data_count']++;
                            continue;
                        }
                        if (empty($data_lname)) {
                            $GLOBALS['not_inserted_list_v2'][] = array_merge(array("NO LAST NAME"), $row);
                            $GLOBALS['not_inserted_data_count']++;
                            continue;
                        }
                        // if (empty($data_mobile)) {
                        //     $GLOBALS['not_inserted_list_v2'][] = array_merge(array("NO MOBILE"), $row);
                        //     $GLOBALS['not_inserted_data_count']++;
                        //     continue;
                        // }

                        $array_data = array(
                            $data_fname,
                            null,
                            $data_lname,
                            $data_suffix,
                            $data_mobile,
                            $data_email,
                            $data_other_mobile,
                            $data_other_email,
                            $data_phone,
                            null,
                            null,
                            null,
                            date('Y-m-d H:i:s'),
                            null,
                            null,
                            $data_company_id,
                            $data_designation_id,
                            $data_unhs,
                            $data_membership_id,
                            $data_handicap,
                            1,
                            1,
                        );

                        $array_data = Utility::nullEmptyArray($array_data);

                        $this->user->createUser($array_data);

                        $GLOBALS['not_inserted_list_v2'][] = array_merge(array("SUCCESS IMPORT"), $row);
                        $GLOBALS['inserted_data_count']++;
                    }
                }

                if (!$header_column_found) {
                    $return_arr["status"] = 2;
                    $return_arr["message"] = " Header not found.";
                    response()->json($return_arr);
                } else {
                    $return_arr["status"] = 1;
                    $return_arr["gen_file"] = $destinationFilename;
                    $return_arr["orig_file"] = $object->getFilename();
                    $return_arr["total"] = $GLOBALS['total_data_count'];
                    $return_arr["inserted"] = $GLOBALS['inserted_data_count'];
                    $return_arr["not_inserted"] = $GLOBALS['not_inserted_data_count'];
                    $return_arr["message"] = " File Uploaded.";


                    ///START GEN LOG
                    $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();

                    $GLOBALS['data_count_list_v2'][] = array("Total Data", (string) ($GLOBALS['total_data_count']));
                    $GLOBALS['data_count_list_v2'][] = array("Inserted Data", (string) ($GLOBALS['inserted_data_count']));
                    $GLOBALS['data_count_list_v2'][] = array("Not Inserted Data", (string) ($GLOBALS['not_inserted_data_count']));
                    // $GLOBALS['data_count_list_v2'][] = array("Import By", (string) Session::get('user')['first_name'] . ' ' . Session::get('user')['last_name']);
                    $GLOBALS['data_count_list_v2'][] = array("Import Date", (string)  date('F d, Y'));


                    $data_count_list_v2_count = count($GLOBALS['data_count_list_v2']);

                    $spreadsheet
                        ->getActiveSheet()
                        ->getStyle('B' . ($data_count_list_v2_count + 1) . ':' . (string) $highestColumn . ($data_count_list_v2_count + 1))
                        ->getFill()
                        ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                        ->getStartColor()
                        ->setARGB('FFFF00');
                    $spreadsheet
                        ->getActiveSheet()
                        ->getStyle('A' . ($data_count_list_v2_count + 1) . '')
                        ->getFill()
                        ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                        ->getStartColor()
                        ->setARGB('FF0000');

                    $spreadsheet->getActiveSheet()->getStyle('A' . ($data_count_list_v2_count + 1))
                        ->getFont()->getColor()->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_WHITE);

                    $sheet = $spreadsheet->getActiveSheet();
                    for ($i = 'A'; $i != $highestColumn; $i++) {
                        $sheet->getColumnDimension($i)->setAutoSize(true);
                    }

                    foreach ($GLOBALS['not_inserted_list_v2'] as $key => $subArr) {
                        unset($subArr[intval($issue_summary_index) + 1]);
                        $GLOBALS['not_inserted_list_v2'][$key] = $subArr;
                    }

                    unset($GLOBALS['row_headers'][intval($issue_summary_index)]);

                    usort($GLOBALS['not_inserted_list_v2'], function ($a, $b) {
                        return $a[0] <=> $b[0];
                    });

                    $GLOBALS['not_inserted_list_v2'] = array_merge(array(array_map("strtoupper", array_merge(array('SUMMARY'), $GLOBALS['row_headers']))),  $GLOBALS['not_inserted_list_v2']);

                    if ($data_count_list_v2_count > 0) {
                        $GLOBALS['not_inserted_list_v2'] = array_merge($GLOBALS['data_count_list_v2'], $GLOBALS['not_inserted_list_v2']);
                    }

                    $sheet->fromArray($GLOBALS['not_inserted_list_v2'], NULL, 'A1');
                    $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($spreadsheet);
                    $writer->save($log_dir .  '/' . $destinationFilename);

                    //END GEN LOG
                    // echo json_encode($return_arr);
                    response()->json($return_arr);
                }
            } catch (\Exception $e) {
                $response['message'] = "Error has occured " . $e;
                $response['status'] = 0;
                response()->json($response);
            }
        }
    }

    public function sendInvitation()
    { //deprecated
        ini_set('max_execution_time', '0');
        set_time_limit(0);
        //same code above
        ini_set('memory_limit', '-1');

        if (empty(input('sms_settings_id'))) {
            response()->json(array("status" => 0, "message" => "Parameter (sms_settings_id) is required."));
        }
        if (empty(input('event_id'))) {
            response()->json(array("status" => 0, "message" => "Parameter (event_id) is required."));
        }

        $sms_settings_id = input('sms_settings_id');
        $sms  = new \App\Models\Sms();
        $sms_settings = $sms->getSettings(array($sms_settings_id));

        if (empty($sms_settings)) {
            response()->json(array("status" => 0, "message" => "Invalid sms_settings_id."));
        }

        if (empty($sms_settings['message_body'])) {
            response()->json(array("status" => 0, "message" => "Message is empty."));
        }

        $event_id = input('event_id');
        $event  = new \App\Models\Event();
        $event_data = $event->getEvent(array($event_id));

        if (empty($event_data)) {
            response()->json(array("status" => 0, "message" => "Invalid event_id."));
        }

        // get users
        $users = $this->user->getUsers();
        $sms_api = config('api')->sms;
        $array_data['uri'] = $sms_api['uri'];

        foreach ($users as $users_row) {
            //check if already send
            $sms_status_arr = $sms->getSmsStatus(array($sms_settings_id, $users_row['id'], $event_id));
            if (empty($sms_status_arr)) {
                $array_data['parameters'] = array(
                    "key" => $sms_api['key'],
                    "mobile" => $users_row['mobile'],
                    "message" => $sms_settings['message_body'],
                );
                $response  = Utility::curl($array_data);
                $response = json_decode($response, true);
                $sms->createLog(array(
                    $sms_settings_id,
                    date('Y-m-d H:i:s'),
                    $users_row['id'],
                    $event_id,
                    $response['status'],
                ));
            }
        }

        response()->json(array(
            "status" => 1,
            "message" => "",
        ));
    }

    public function usersImportSummaryDownload()
    {
        $log_dir = env('APP_DISK') . "/import/users/logs/";
        $file = $log_dir . input('file');

        $fp = fopen($file, 'rb');

        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . escape(input('name')) . '" ');
        header('Content-Length: ' . filesize($file));
        fpassthru($fp);
    }

    public function usersQR()
    {

        header("Content-Type: image/png");

        if (empty(input('id')) || empty(input('event_id'))) {
            response()->json(array("status" => 0, "message" => "Invalid data."));
        }

        $user_data =   $this->user->getUser(
            array(
                input('id'),
            )
        );

        if (empty($user_data)) {
            response()->json(array("status" => 0, "message" => "Invalid data."));
        }

        $event  = new \App\Models\Event();
        $event_data = $event->getEvent(array(input('event_id')));

        if (empty($event_data)) {
            response()->json(array("status" => 0, "message" => "Invalid event_id."));
        }

        $qr_data['id'] = intval(input('id'));
        $qr_data['data'] = array(
            array(
                "event_id" => intval(input('event_id'))
            ),
        );

        // echo json_encode($qr_data);
        // exit;
        $array_data['uri']  = config('api')->qr['uri'];
        $name = $user_data['firstname'] . ' ' . $user_data['lastname'];
        $array_data['parameters'] = array(
            "key" => config('api')->qr['key'],
            "data" => json_encode($qr_data),
            "logo" => true,
            "label" =>  strlen($name) <= 20 ? $name : $user_data['firstname'],
        );
        // $array_data['header'] = array("Content-Type: image/jpeg");

        $response  = Utility::curl($array_data);

        echo $response;
    }

    public function usersTemplateDownload()
    {
        $log_dir = env('APP_DISK') . "/import/users/";
        $file = $log_dir . 'User_Template.xlsx';

        $fp = fopen($file, 'rb');

        header("Content-Type: application/octet-stream");
        header("Content-Disposition: attachment; filename=User_Template.xlsx");
        header("Content-Length: " . filesize($file));
        fpassthru($fp);
    }
    public function updateStatus()
    {
        $this->user->updateUserStatus(
            array(
                intval(input('status')) ? input('status') : null,
                intval(input('active')) ? input('active') : null,
                input('id'),
            )
        );
        response()->json(array(
            "status" => 1,
            "message" => "Successfully saved.",
        ));
    }

    public function updateEventStatus()
    {
        $this->user->updateUserEventStatus(
            array(
                intval(input('status')) ? input('status') : null,
                input('id'),
            )
        );
        response()->json(array(
            "status" => 1,
            "message" => "Successfully saved.",
        ));
    }

    public function removeFromTeam()
    {
        $this->user->removeUserFromTeam(
            array(
                input('id'),
            )
        );
        response()->json(array(
            "status" => 1,
            "message" => "Successfully saved.",
        ));
    }
    public function adminsIndex()
    {
        $page_title = "Admins";
        View::render('admin/list', get_defined_vars());
    }

    public function adminList()
    {

        $array_data['search_keyword'] = input('search')['value'];
        $array_data['search_type'] = json_decode(input('search_type'), true)[0];
        $array_data['sort'] = input('order')[0]['dir'];
        $array_data['order'] = input('columns')[input('order')[0]['column']]['data'];
        $array_data['offset'] = input('start');
        $array_data['limit'] = input('length');

        $array_data['offset_limit'] = " LIMIT {$array_data['offset']},{$array_data['limit']}";
        $array_data['sort'] = intval(input('draw')) == 1 ?  " ORDER BY name ASC " : " ORDER BY {$array_data['order']} {$array_data['sort']} ";

        //start search using keywords
        if (empty($array_data['search_keyword'])) {
            $array_data['search_keyword'] = "1";
            $array_data['filters'] = " AND  ? ";
        } else {
            switch ($array_data['search_type']) {
                case "ID":
                    $array_data['filters'] = " AND u.id = ? ";
                    break;
                case "Name":
                    $array_data['filters'] = " AND CONCAT(u.lastname,', ',u.firstname,' ',u.lastname,' ',u.firstname) LIKE ? ";
                    $array_data['search_keyword'] = "%" . $array_data['search_keyword'] . "%";
                    break;
            }
        }

        $array_data['admin_filter'] = "  AND u.id NOT IN (?) ";
        $array_data['admin_id'] =  Auth::user()->id;


        $results =  $this->user->getAdmins($array_data);

        $result['data'] = array();
        foreach ($results as $row) {
            $result['data'][] = array(
                "id" => $row['id'],
                "name" => $row['name'],
                "created_at" => $row['created_at'] ? date('m/d/Y', strtotime($row['created_at'])) : NULL,
                "active" => $row['active'],
            );
        }

        $result['draw'] = input('draw');
        $result['recordsTotal'] = $this->user->getAdminsCount($array_data);
        $result['recordsFiltered'] = $this->user->getAdminsFilteredCount($array_data);

        response()->json($result);
    }

    public function getUser()
    {
        $response =   $this->user->getUser(
            array(
                input('id'),
            )
        );

        response()->json($response);
    }
    public function getPlayer()
    {

        $response =   $this->user->getPlayer(
            array(
                input('event_id'),
                input('user_id'),
            )
        );

        response()->json($response);
    }
    public function options()
    {

        $array_data['search'] = input('search');
        $array_data['exclude_id'] = input('exclude_id');
        $array_data['search'] = "%{$array_data['search']}%";
        $array_data['limit'] = input('limit');
        $response = $this->user->getUserOptions(
            array(
                $array_data['search'],
                $array_data['exclude_id'],
                $array_data['limit']
            )
        );
        if (empty(input('search'))) {
            $results = array_merge(array(array("id" => 0, "text" => "Please Select")), $response);
        } else {
            $results = $response;
        }

        response()->json($results);
    }

    public function mateOption()
    {

        $array_data['search'] = input('search');
        $array_data['exclude_id'] = input('exclude_id');
        $array_data['event_id'] = input('event_id');
        $array_data['search'] = "%{$array_data['search']}%";
        $array_data['limit'] = input('limit');
        $array_data['course'] = input('course');
        $array_data['flight'] = input('flight');
        $array_data['course_cat'] = input('course_cat');
        // $player_data =   $this->user->getPlayer(
        //     array(
        //         $array_data['event_id'],
        //         $array_data['exclude_id'],
        //     )
        // );
        // if (empty($player_data['course']) || empty($player_data['course'])) {
        //     response()->json(array());
        // }

        $response = $this->user->getUserMateOptions(
            array(
                $array_data['search'],
                $array_data['exclude_id'],
                $array_data['event_id'],
                $array_data['course'],
                $array_data['flight'],
                $array_data['course_cat'],
                $array_data['limit']
            )
        );
        if (empty(input('search'))) {
            $results = array_merge(array(array("id" => 0, "text" => "Please Select")), $response);
        } else {
            $results = $response;
        }

        response()->json($results);
    }

    public function userEventTeamOptions()
    {

        $array_data['search'] = input('search');
        $array_data['event_id'] = input('event_id');
        $array_data['team_id'] = input('team_id');
        $array_data['search'] = "%{$array_data['search']}%";
        $array_data['limit'] = input('limit');
        $response = $this->user->getUserEventTeamOptions(
            array(
                $array_data['search'],
                $array_data['team_id'],
                // $array_data['event_id'],
                $array_data['limit']
            )
        );
        if (empty(input('search'))) {
            $results = array_merge(array(array("id" => 0, "text" => "Please Select")), $response);
        } else {
            $results = $response;
        }

        response()->json($results);
    }

    public function teamOptions()
    {

        $array_data['search'] = input('search');
        $array_data['event_id'] = input('event_id');
        $array_data['search'] = "%{$array_data['search']}%";
        $array_data['limit'] = input('limit');
        $results = array_merge(array(array("id" => 0, "text" => "Please Select")), $this->user->getTeamOptions(
            array(
                $array_data['search'],
                $array_data['event_id'],
                $array_data['limit']
            )
        ));
        response()->json($results);
    }


    public function teamFilterOptions()
    {

        $array_data['search'] = input('search');
        $array_data['event_id'] = input('event_id');
        $array_data['search'] = "%{$array_data['search']}%";
        $array_data['limit'] = input('limit');
        $results = array_merge(array(array("id" => 0, "text" => "Please Select")), $this->user->getTeamFilterOptions(
            array(
                $array_data['search'],
                $array_data['event_id'],
                $array_data['limit']
            )
        ));
        response()->json($results);
    }

    public function storePlayer()
    {

        $registration_date = input('registration_status') == 'registered' ? date('Y-m-d H:i:s') : null;


        $array_data = array(
            input('event'),
            input('course'),
            intval(input('team')) ? input('team') : null,
            input('division'),
            input('user_id'),
            input('course_n'),
            input('flight_n'),
            intval(input('mate')) ? input('mate') : null,
            input('registration_status'),
            input('registration_type'),
            $registration_date,
            date('Y-m-d H:i:s'),
            1,
        );

        $array_data = array_map(array(new Utility(), 'cleanString'), $array_data);
        $array_data = Utility::nullEmptyArray($array_data);
        // $array_data = array_map(array(new Utility(), 'toUpperCase'), $array_data);

        $player_id = $this->user->createPlayer($array_data);

        response()->json(array(
            "status" => 1,
            "player_id" => $player_id,
            "message" => "Successfully saved.",
        ));
    }

    public function teamsData()
    {


        $array_data['search_keyword'] = input('search')['value'];
        $array_data['search_type'] = json_decode(input('search_type'), true)[0];
        $array_data['sort'] = input('order')[0]['dir'];
        $array_data['order'] = input('columns')[input('order')[0]['column']]['data'];
        $array_data['offset'] = input('start');
        $array_data['limit'] = input('length');
        // $array_data['team_id'] = input('team_id');
        $array_data['team_id'] = !empty(input('team_id')) ? ' AND p.team_id = ' . input('team_id') : '';
        $array_data['event_id'] = input('event_id');

        $array_data['course'] = !empty(input('course')) ? ' AND c.id = ' . input('course') : '';
        $array_data['course_n'] = !empty(input('course_n')) ? ' AND p.course = ' . input('course_n') : '';
        $array_data['flight_n'] = !empty(input('flight_n')) ? ' AND p.flight = "' . input('flight_n') . '"' : '';


        $array_data['offset_limit'] = " LIMIT {$array_data['offset']},{$array_data['limit']}";
        $array_data['sort'] = intval(input('draw')) == 1 ?  " ORDER BY p_created_at ASC " : " ORDER BY {$array_data['order']} {$array_data['sort']} ";

        //start search using keywords
        if (empty($array_data['search_keyword'])) {
            $array_data['search_keyword'] = "1";
            $array_data['filters'] = " AND  ? ";
        } else {
            switch ($array_data['search_type']) {
                case "Member ID":
                    $array_data['filters'] = " AND u.id = ? ";
                    break;
                case "Member Name":
                    $array_data['filters'] = " AND CONCAT(u.lastname,', ',u.firstname,' ',u.lastname,' ',u.firstname) LIKE ? ";
                    $array_data['search_keyword'] = "%" . $array_data['search_keyword'] . "%";
                    break;
                case "Member Email":
                    $array_data['filters'] = " AND u.email = ? ";
                    break;
                case "Member Mobile":
                    $array_data['search_keyword'] = ltrim($array_data['search_keyword'], '0');
                    $array_data['filters'] = " AND u.mobile = ? ";
                    break;
            }
        }

        $array_data['where'] = $array_data['team_id'] . $array_data['course'] . $array_data['course_n'] . $array_data['flight_n'];

        $results =  $this->user->getTeamUsersList($array_data);

        $result['data'] = array();
        foreach ($results as $row) {
            $row  = Utility::emptyNullArray($row);
            $result['data'][] = array(
                "id" => $row['id'],
                "player_id" => $row['player_id'],
                "name" => $row['name'],
                "mobile" => $row['mobile'],
                "email" => $row['email'],
                "division" => $row['division'],
                "course" => $row['course'],
                "team" => $row['team'],
                "course_flight" => $row['course_flight'],
                "created_at" => $row['created_at'] ? date('m/d/Y', strtotime($row['created_at'])) : NULL,
                "registration_status" => $row['registration_status'],
                "registration_type" => $row['registration_type'],
                "registration_date" =>  $row['registration_date'] ? date('m/d/Y', strtotime($row['registration_date'])) : NULL,
                "p_created_at" => $row['p_created_at'] ? date('m/d/Y', strtotime($row['p_created_at'])) : NULL,

            );
        }

        $result['draw'] = input('draw');
        $result['recordsTotal'] = $this->user->getTeamUsersListCount($array_data);
        $result['recordsFiltered'] = $this->user->getTeamListFilteredCount($array_data);

        response()->json($result);
    }


    public function courseFlightData()
    {
        $array_data['search_keyword'] = input('search');
        $array_data['search_type'] = json_decode(input('search_type'), true)[0];
        $array_data['team_id'] = !empty(input('team_id')) ? ' AND p.team_id = ' . input('team_id') : '';
        $array_data['event_id'] = input('event_id');

        $array_data['course'] = !empty(input('course')) ? ' AND c.id = ' . input('course') : '';

        $array_data['course_n'] = !empty(input('course_n')) ? ' AND p.course = "' . input('course_n') . '"' : '';
        $array_data['flight_n'] = !empty(input('flight_n')) ? ' AND p.flight = "' . input('flight_n') . '"' : '';

        $array_data['offset_limit'] = " LIMIT 0,999 ";
        // $array_data['sort'] = " ORDER BY u.firstname ASC ";
        $array_data['sort'] = " ORDER BY t.name ASC ";

        //start search using keywords
        if (empty(input('search'))) {
            $array_data['search_keyword'] = "1";
            $array_data['filters'] = " AND  ? ";
        } else {
            switch ($array_data['search_type']) {
                case "Member ID":
                    $array_data['filters'] = " AND (u.id = ?  %s) ";
                    break;
                case "Member Name":
                    $array_data['filters'] = " AND (CONCAT(u.lastname,', ',u.firstname,' ',u.lastname,' ',u.firstname) LIKE ?  %s) ";
                    $array_data['search_keyword'] = "%" . $array_data['search_keyword'] . "%";
                    break;
                case "Member Email":
                    $array_data['filters'] = " AND (u.email = ? %s)";
                    break;
                case "Member Mobile":
                    $array_data['search_keyword'] = ltrim($array_data['search_keyword'], '0');
                    $array_data['filters'] = " AND (u.mobile = ? %s) ";
                    break;
            }
        }

        $static_where = $array_data['team_id'] . $array_data['course_n'] .  $array_data['flight_n'];
        // $array_data['where'] = $array_data['team_id'] . $array_data['course'];
        $array_data['where'] =  $array_data['course'] . $static_where;

        // hide 
        $show_other_location = true;
        if (!empty($static_where) || !empty(input('search'))) {
            $show_other_location = false;
        }

        // OR (p.flight IN ('A') AND p.course IN ('1'))
        if (!empty(input('search'))) {
            $tmp_filter = $array_data['filters'];
            $array_data['filters'] = sprintf($array_data['filters'], '');

            $result_course_flights =  $this->user->getTeamUsersListSame($array_data, 'p.course,p.flight');
            $incl_loc = [];
            foreach ($result_course_flights as $result_course_flight) {
                $incl_loc[] = "p.course = '{$result_course_flight['course']}' AND p.flight = '{$result_course_flight['flight']}'";
            }

            if (empty($incl_loc)) {

                $array_data['filters'] = sprintf($tmp_filter, "  ");
            } else {
                $incl_loc_str =   "(" . implode(") OR (", array_flatten($incl_loc)) . ")";
                $array_data['filters'] = sprintf($tmp_filter, " OR (" . $incl_loc_str . ") ");
            }
        } else {
            $array_data['filters'] = sprintf($array_data['filters'], '');
        }

        $results =  $this->user->getTeamUsersList($array_data);


        $result = array();
        foreach ($results as $row) {
            $row['attendance'] = $row['attendance'] ? date('h:i A', strtotime($row['attendance'])) : NULL;
            $result[$row['course_n']][$row['flight_n']][] = $row;
        }
        response()->json(array("data" => Utility::emptyNullArray($result), "show" => $show_other_location));
    }

    public function createReward()
    {
        $array_data = array(
            input('event_id'),
            Auth::user()->id,
            input('player_id'),
            date('Y-m-d H:i:s'),
            1,
        );

        $player_data = $this->user->getPlayer(
            array(
                input('event_id'),
                input('player_id'),
            )
        );

        if ($player_data['registration_status'] != 'registered') {
            response()->json(array("status" => 0, "message" => "Player is not registered."));
        }

        // $array_data = array_map(array(new Utility(), 'cleanString'), $array_data);
        // $array_data = Utility::nullEmptyArray($array_data);
        // $array_data = array_map(array(new Utility(), 'toUpperCase'), $array_data);


        $reward_id = $this->user->createReward($array_data);


        response()->json(array(
            "status" => 1,
            "reward_id" => $reward_id,
            "message" => "Successfully saved.",
        ));
    }

    public function rewardClaimCount()
    {
        $array_data = array(
            input('event_id'),
            input('player_id'),
        );

        // $array_data = array_map(array(new Utility(), 'cleanString'), $array_data);
        // $array_data = Utility::nullEmptyArray($array_data);
        // $array_data = array_map(array(new Utility(), 'toUpperCase'), $array_data);


        $count = $this->user->getRewardCount($array_data);


        response()->json(array(
            "status" => 1,
            "count" => $count,
            "message" => "",
        ));
    }
    public function mulliganCount()
    {
        $array_data = array(
            input('event_id'),
            input('player_id'),
        );

        // $array_data = array_map(array(new Utility(), 'cleanString'), $array_data);
        // $array_data = Utility::nullEmptyArray($array_data);
        // $array_data = array_map(array(new Utility(), 'toUpperCase'), $array_data);


        $count = $this->user->getMulliganCount($array_data);


        response()->json(array(
            "status" => 1,
            "count" => intval($count) ?  $count : "",
            "message" => "",
        ));
    }
    public function updateMulligan()
    {
        $array_data = array(
            input('event_id'),
            input('mulligan'),
            Auth::user()->id,
            input('player_id'),
            date('Y-m-d H:i:s'),
            1,
        );

        // $array_data = array_map(array(new Utility(), 'cleanString'), $array_data);
        // $array_data = Utility::nullEmptyArray($array_data);
        // $array_data = array_map(array(new Utility(), 'toUpperCase'), $array_data);

        $player_data = $this->user->getPlayer(
            array(
                input('event_id'),
                input('player_id'),
            )
        );

        if ($player_data['registration_status'] != 'registered') {
            response()->json(array("status" => 0, "message" => "Player is not registered."));
        }


        $mulligan_id = $this->user->updateMulligan($array_data);

        response()->json(array(
            "status" => 1,
            "mulligan_id" => $mulligan_id,
            "message" => "Successfully saved.",
        ));
    }

    public function QrPlayerInfo()
    {

        $has_access = false;
        $device_ids = $this->user->getDeviceIds();
        foreach ($device_ids as $device_id) {
            if ($device_id['device_id'] == input('device_id')) {
                $has_access = true;
                break;
            }
        }
        if (!$has_access) {
            response()->json(array("status" => 0, "message" => "Device has no access."));
        }

        $response = $this->user->getPlayer(
            array(
                input('event_id'),
                input('user_id'),
            )
        );


        if (!count($response)) {
            $response['status'] = 0;
            $response['message'] = "No data found.";
            response()->json($response);
        } else if ($response['registration_status'] != 'registered') {
            $response['status'] = 0;
            $response['message'] = "Player is not registered.";
            response()->json($response);
        }

        //get recourd claim count
        $array_data_reward = array(
            input('event_id'),
            input('user_id'),
        );
        $count = $this->user->getRewardCount($array_data_reward);
        $response['claim_count'] = $count;

        $attendance = $this->user->getPlayerAttendance(
            array(
                $response['id'],
            )
        );
        $response['attendance'] = $attendance;

        $array_data_mulligan = array(
            input('event_id'),
            input('user_id'),
        );
        $mulligan = $this->user->getMulliganCount($array_data_mulligan);
        $response['mulligan'] = intval($mulligan);
        response()->json($response);
    }

    public function QrPlayerClaim()
    {
        //START POSSIBLE QR APP MIDDLEWARE

        $has_access = false;
        $device_ids = $this->user->getDeviceIds();
        foreach ($device_ids as $device_id) {
            if ($device_id['device_id'] == input('device_id')) {
                $has_access = true;
                break;
            }
        }
        if (!$has_access) {
            response()->json(array("status" => 0, "message" => "Device has no access."));
        }

        $response = $this->user->getPlayer(
            array(
                input('event_id'),
                input('user_id'),
            )
        );

        if (!count($response)) {
            $response['status'] = 0;
            $response['message'] = "No data found.";
            response()->json($response);
        } else if ($response['registration_status'] != 'registered') {
            $response['status'] = 0;
            $response['message'] = "Player is not registered.";
            response()->json($response);
        }

        //END POSSIBLE QR APP MIDDLEWARE

        $array_data = array(
            input('event_id'),
            input('user_id'),
            date('Y-m-d H:i:s'),
            1,
        );

        $reward_id = $this->user->createRewardQR($array_data);

        $response['reward_id'] = $reward_id;
        $response['status'] = 1;
        $response['message'] = "Claim success.";

        response()->json($response);
    }

    public function QrPlayerMulligan()
    {
        //START POSSIBLE QR APP MIDDLEWARE

        $has_access = false;
        $device_ids = $this->user->getDeviceIds();
        foreach ($device_ids as $device_id) {
            if ($device_id['device_id'] == input('device_id')) {
                $has_access = true;
                break;
            }
        }
        if (!$has_access) {
            response()->json(array("status" => 0, "message" => "Device has no access."));
        }

        $response = $this->user->getPlayer(
            array(
                input('event_id'),
                input('user_id'),
            )
        );

        if (!count($response)) {
            $response['status'] = 0;
            $response['message'] = "No data found.";
            response()->json($response);
        } else if ($response['registration_status'] != 'registered') {
            $response['status'] = 0;
            $response['message'] = "Player is not registered.";
            response()->json($response);
        }

        //END POSSIBLE QR APP MIDDLEWARE

        $array_data = array(
            input('event_id'),
            input('mulligan'),
            input('user_id'),
            date('Y-m-d H:i:s'),
            1,
        );

        $mulligan_id = $this->user->updateMulliganQR($array_data);

        response()->json(array(
            "status" => 1,
            "mulligan_id" => $mulligan_id,
            "message" => "Successfully saved.",
        ));
    }


    public function QrPlayerUpdate()
    {
        $has_access = false;
        $device_ids = $this->user->getDeviceIds();
        foreach ($device_ids as $device_id) {
            if ($device_id['device_id'] == input('device_id')) {
                $has_access = true;
                break;
            }
        }
        if (!$has_access) {
            response()->json(array("status" => 0, "message" => "Device has no access."));
        }
        $array_data = json_decode(input('data'), true);

        //check if already attended
        $response = $this->user->getPlayerAttendance(
            array(
                $array_data['player_id'],
            )
        );

        if ($response) {
            response()->json(array("status" => 1, "message" => "Attendance already added."));
        }

        //insert
        $response = $this->user->setPlayerAttendance(
            array(
                $array_data['player_id'],
                // date('Y-m-d H:i:s', strtotime($array_data['time'])),                
                date('Y-m-d H:i:s'),
                1,
            )
        );

        response()->json(array("status" => 1, "message" => "Attendance added."));
        //update
    }

    public function setAttendance()
    {


        $player_data = $this->user->getPlayerData(
            array(
                input('id'),
            )
        );

        if (empty(input('remove'))) {
            if ($player_data['registration_status'] != 'registered') {
                response()->json(array("status" => 0, "message" => "Player is not registered."));
            }

            //insert
            $id = $this->user->setPlayerAttendance(
                array(
                    input('id'),
                    date('Y-m-d H:i:s'),
                    1,
                )
            );
        } else {
            $this->user->removePlayerAttendance(
                array(
                    input('id'),
                )
            );
        }


        response()->json(array("status" => 1, "message" => "Attendance updated."));
    }
    
    public function bootClaim()
    {


        // $player_data = $this->user->getPlayerData(
        //     array(
        //         input('id'),
        //     )
        // );

        $player_id = input('player_id');
        $event_id =input('event_id');
        $booth_id = input('booth_id');
        $param =[$event_id,$player_id,$booth_id];
        // echo $player_id;exit;
        $is_time_in =($this->user->checkPlayerAttendance($player_id)->num_rows ==1 ? true : false);
          if (!$is_time_in) {
                response()->json(array("status" => 0, "message" => "Player must time in first before making any claim in this booth."));
            }
        if (empty(input('remove'))) {
            // if ($player_data['registration_status'] != 'registered') {
            //     response()->json(array("status" => 0, "message" => "Player is not registered."));
            // }
             $res =$this->user->inserBootClaimed(
                            $param
                    );
             if(!$res)
             {
                response()->json(array("status" => 0, "message" => "Boot Claim Unsuccessfull."));
             }
        } else {
                 $res =$this->user->updateBootClaim(
                            $param
                    );

                if(!$res)
                 {
                    response()->json(array("status" => 0, "message" => "Boot Claim Unsuccessfull."));
                 }
        }
        response()->json(array("status" => 1, "message" => "Boot Claim updated."));
    }

    public function QrDevice()
    {

        if (empty(input('device_id'))) {
            response()->json(array("status" => 0, "message" => "Invalid device id."));
        }

        $id = $this->user->createDevice(
            array(
                input('device_id'),
                input('description'),
            )
        );

        if (!$id) {
            response()->json(array("status" => 0, "message" => "Request already sent."));
        }

        response()->json(array("status" => 1, "message" => "Request sent."));
    }
}
