<?php

namespace App\Controllers;

use App\Core\Controller;
use App\Core\View;
use App\Utilities\Uuid;
use App\Utilities\Cookie;
use App\Utilities\Utility;
use Firebase\JWT\JWT;
use App\Utilities\Auth;

class DeviceController extends Controller
{
    private $device;
    function __construct()
    {
        $this->device = new \App\Models\Device;
    }
    public function devicesIndex()
    {
        $page_title = "Devices List";

        View::render('device/list', get_defined_vars());
    }

    public function list()
    {
        $array_data['search_keyword'] = input('search')['value'];
        $array_data['search_type'] = json_decode(input('search_type'), true)[0];
        $array_data['sort'] = input('order')[0]['dir'];
        $array_data['order'] = input('columns')[input('order')[0]['column']]['data'];
        $array_data['offset'] = input('start');
        $array_data['limit'] = input('length');

        $array_data['offset_limit'] = " LIMIT {$array_data['offset']},{$array_data['limit']}";
        $array_data['sort'] = intval(input('draw')) == 1 ?  " ORDER BY created_at DESC " : " ORDER BY {$array_data['order']} {$array_data['sort']} ";

        //start search using keywords
        if (empty($array_data['search_keyword'])) {
            $array_data['search_keyword'] = "1";
            $array_data['filters'] = " AND  ? ";
        } else {
            switch ($array_data['search_type']) {
                case "ID":
                    $array_data['filters'] = " AND id = ? ";
                    break;
                case "Description":
                    $array_data['filters'] = " AND description LIKE ? ";
                    $array_data['search_keyword'] = "%" . $array_data['search_keyword'] . "%";
                    break;
                case "Device ID":
                    $array_data['filters'] = " AND device_id = ? ";
                    break;
            }
        }

        $results =  $this->device->getDevices($array_data);

        $result['data'] = array();
        foreach ($results as $row) {
            $result['data'][] = array(
                "id" => $row['id'],
                "description" => $row['description'],
                "device_id" => $row['device_id'],
                "created_at" => $row['created_at'],
                "status" => $row['status'],
            );
        }

        $result['draw'] = input('draw');
        $result['recordsTotal'] = $this->device->getDevicesListCount($array_data);
        $result['recordsFiltered'] = $this->device->getDevicesListFilteredCount($array_data);

        response()->json($result);
    }

    public function status()
    {
        $this->device->updateDeviceStatus(
            array(
                intval(input('status')) ? input('status') : NULL,
                input('id'),
            )
        );
        response()->json(array(
            "status" => 1,
            "message" => "Successfully saved.",
        ));
    }

    public function remove()
    {
        $this->device->removeDevice(
            array(
                input('id'),
            )
        );
        response()->json(array(
            "status" => 1,
            "message" => "Successfully saved.",
        ));
    }
}
