<?php

namespace App\Controllers\Admin;

use App\Core\View;
use App\Utilities\Hash;
use App\Utilities\Session;
use App\Utilities\Cookie;
use App\Utilities\Token;
use App\Utilities\Utility;
use App\Core\Controller;
use App\Models\Configuration;

class ConfigurationController extends Controller {
    private $configuration;

    function __construct() {
        $this->configuration = new \App\Models\Configuration;
    }

    public function smsIndex() {
        View::render('admin/configuration/sms_settings');
    }

    public function addPlayerPage() {
        View::render('admin/data_management/add_player');
    }

    public function listPlayerPage() {
        View::render('admin/data_management/list_player');
    }

    public function smsSetup() {
        $kind = input('kind');

        if($kind == "update"){
            $json_arr['type'] = input('type');
            $json_arr['header'] = input('header');
            $json_arr['body'] = input('body');
            $json_arr['footer'] = input('footer');
            $json_arr['status'] = input('status');
            $response = array();

            $query_status = $this->configuration->smsSetupUpdate($json_arr);

            response()->json($query_status);
        }
        else if($kind == "load"){
            $json_arr['type'] = input('type');

            $query_status = $this->configuration->smsSetupLoad($json_arr);

            response()->json($query_status);
        }
    }
}
